''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
'                                                                        '
' ACD ChemBasic                                                          '
'                                                                        '
' SOLcalc.BAS                                                            '
'                                                                        '
' This ChemBasic demo program calculates the weigth of compound which is '
' required to prepare the solution of known molar concentration          '
'                                                                        '
' NB: the compound of interest should be the 1st (or, better, the only)  '
'     molecule on the ChemSketch's active page                           '
'                                                                        '
'                                                                        '
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''

''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Function Main As String
''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''
Dim volume As Double, mmAss As Double, weight As Double, conc As Double, bf As String
Dim nd As Integer, Form, Diagram As object

  'Checking for presence and quantity
  nd = ActiveDocument.ActivePage.Diagrams.Count
  If nd < 1 Then
    Main = "There are no structures on your page." + Chr(13) + Chr(13) + "Draw structure and restart Solution Calculator."
    Exit Function
  Else
    If nd > 1 Then 
      Main = "There are several structures on your page." + Chr(13) + Chr(13) + "Keep one structure on the page and restart Solution Calculator."
      Exit Function
    Else
      Diagram = ActiveDocument.ActivePage.Diagrams.Item(1)
    End If 
  End If

  bf = Diagram.GetBrutto
  mmAss = Diagram.GetMolWeight
  volume = 250
  conc = 0.001

  Do
    'Display dialog
    Form = ReadFormFromLib("Solcalc.frl", "Solution Calculator - Input Data")
    Form.SetDblValue("Volume", volume)
    Form.SetDblValue("Concentration", conc)
    If Form.ExecForm Then
      conc = Form.GetDblValue("Concentration")
      volume = Form.GetDblValue("Volume")
    Else
      Main = "Cancelled"
      Exit Function
    End If
  
    'Checking for validity
    If conc = 0.0 Then
      Main = "ERROR: Invalid concentration"
      Exit Function
    End If
  
    If volume = 0.0 Then
      Main = "ERROR: Invalid volume"
      Exit Function
    End If
    weight = conc * (0.001 * volume) * mmass
  
    ' Display results
    Form=ReadFormFromLib("Solcalc.frl", "Solution Calculator - Results")
    Form.SetStrValue("Compound", bf)
    Form.SetStrValue("MolarMass", FStr(mmAss,2,2))
    Form.SetStrValue("Concentration", Str(conc) + " M/l")
    Form.SetStrValue("Volume", Str(volume) + " ml")
    Form.SetStrValue("REQUIRED", LTrim(FStr(weight,12,4)) + " grams")
  Loop While Form.ExecForm

  Main = "Completed."

End Function
